/* Apvtran.hpp ; VST SDK-based header file for pvtran effect, Richard Dobson march 2001 */
/* NB parts of this file (c)1999 Steinberg Soft+Hardware GmbH */

#ifndef __APVTRAN_H
#define __APVTRAN_H

#include "audioeffectx.h"
#include <transform.h>


class Apvtran : public AudioEffectX
{
public:
	Apvtran(audioMasterCallback audioMaster);
	~Apvtran();

	virtual void process(float **inputs, float **outputs, long sampleFrames);
	virtual void processReplacing(float **inputs, float **outputs, long sampleFrames);
	virtual void setProgramName(char *name);
	virtual void getProgramName(char *name);
	virtual void setParameter(long index, float value);
	virtual float getParameter(long index);
	virtual void getParameterLabel(long index, char *label);
	virtual void getParameterDisplay(long index, char *text);
	virtual void getParameterName(long index, char *text);
	/*RWD */
	virtual void setSampleRate(float sampleRate);
protected:
	spectraltransposer *ptran;
	float semitone_interval;
	float prev_interval;
	float rampsamps;
	float semitone_incr;
	char programName[32];
	float calcsemi(void);
	double d_srate;
};

#endif
