/* Apvtran.cpp : main file for pvtran VST plugin implementation,(c) Richard Dobson March 2001 */
/* NB parts of this file (c)1999 Steinberg Soft+Hardware GmbH */ 
#include <math.h>
#include "Apvtran.hpp"
#include <pvpp.h>

/* this is used for de-zippering; not always needed */
#define RAMPSAMPS (128)

//-----------------------------------------------------------------------------
Apvtran::Apvtran(audioMasterCallback audioMaster)
	: AudioEffectX(audioMaster, 1, 1)	// 1 program, 1 parameter only
{
	semitone_interval = 0.5f;			/* slide pos: --> 0 semitones */		
	prev_interval = semitone_interval;			
	rampsamps = (float) RAMPSAMPS;
	semitone_incr = 0.0;
	// this ~should~ work...
	d_srate = audioMaster(&cEffect, audioMasterGetSampleRate, 0, 0, 0, 0);;
	// but actually we have to use this
	d_srate = sampleRate;
	ptran = 0;
	/*RWD needs to throw exception, assuming host can handle it...?*/
	ptran = new spectraltransposer();
	/*  overlap 1024:160  almost sufficient for clean octave transposition	 */
	if(!ptran->init((long)d_srate,1024,160,PVPP_STREAMING))	{
		delete ptran;
		ptran = 0;
	}

	setNumInputs(1);		// mono in
	setNumOutputs(1);		// mono out
	setUniqueID('PVTR');	// identify	   /* final name PVTR */
	//canMono();				// makes sense to feed both inputs with the same signal
	canProcessReplacing();	// supports both accumulating and replacing output
	strcpy(programName, "PVTransp");	// default program name
}

//-----------------------------------------------------------------------------------------
Apvtran::~Apvtran()
{	
	if(ptran)  {
		delete ptran;
		ptran = 0;
	}
}

//-----------------------------------------------------------------------------------------
void Apvtran::setProgramName(char *name)
{
	strcpy(programName, name);
}

//-----------------------------------------------------------------------------------------
void Apvtran::getProgramName(char *name)
{
	strcpy(name, programName);
}

//-----------------------------------------------------------------------------------------
void Apvtran::setParameter(long index, float value)
{	
	semitone_interval = value;
	if(prev_interval != semitone_interval)
		semitone_incr = (float) fabs(semitone_interval - prev_interval) / rampsamps ;	
}

//-----------------------------------------------------------------------------------------
float Apvtran::getParameter(long index)
{
	return semitone_interval;
}

//-----------------------------------------------------------------------------------------
void Apvtran::getParameterName(long index, char *label)
{
	strcpy(label, " Transposition ");
}

//-----------------------------------------------------------------------------------------
void Apvtran::getParameterDisplay(long index, char *text)
{
	float2string((prev_interval* 24.0f) - 12.0f, text);				
}

//-----------------------------------------------------------------------------------------
void Apvtran::getParameterLabel(long index, char *label)
{
	strcpy(label, " Semitones ");
}


void Apvtran::setSampleRate (float sampleRate)
{
	AudioEffectX::setSampleRate (sampleRate);
	/* RWD TODO:  get this into the phase vocoders properly! */

	d_srate = sampleRate;
	
}



//-----------------------------------------------------------------------------------------
void Apvtran::process(float **inputs, float **outputs, long sampleFrames)
{
    float *in1  =  inputs[0];
    
    float *out1 = outputs[0];
    
	float thissemi;
	if(ptran){
		while(--sampleFrames >= 0){
			thissemi = calcsemi();			
			*out1++ += ptran->tick(*in1++,(thissemi * 24.0f) - 12.0f);			
		}
	}
	else {
		while(--sampleFrames >= 0)
			(*out1++) += (*in1++) * 0.1f;	/* we can hear if there is a problem... */
	}								   
}

//-----------------------------------------------------------------------------------------
void Apvtran::processReplacing(float **inputs, float **outputs, long sampleFrames)
{
    float *in1  =  inputs[0]; 
    float *out1 = outputs[0];
	float thissemi;
	if(ptran){
		while(--sampleFrames >= 0){
			thissemi = calcsemi();			
			*out1++ = ptran->tick(*in1++,(thissemi * 24.0f) - 12.0f);			
		}
	}
	else {
		while(--sampleFrames >= 0)
			(*out1++) = (*in1++) * 0.1f;	/* we can hear if there is a problem... */
	}
}

/************* CUSTOM FUNCTIONS */
/* (will-be) generic function to smooth extreme parameter changes */
float Apvtran::calcsemi(void)
{	
	if(prev_interval== semitone_interval)
		return prev_interval;

	if(semitone_interval > prev_interval)
		prev_interval += semitone_incr;
	else if(semitone_interval < prev_interval)
		prev_interval -= semitone_incr;

	if((float) fabs(semitone_interval - prev_interval) < semitone_incr)
	   prev_interval = semitone_interval;
	return prev_interval;
}
