/* Apvexag.hpp header file for pvexag VST plugin (c) Richard Dobson March 2001 */
/* NB parts of this file (c)1999 Steinberg Soft+Hardware GmbH */

#ifndef __APVEXAG_H
#define __APVEXAG_H

#include "audioeffectx.h"
#include <transform.h>





class Apvexag : public AudioEffectX
{
public:
	Apvexag(audioMasterCallback audioMaster);
	~Apvexag();

	virtual void process(float **inputs, float **outputs, long sampleFrames);
	virtual void processReplacing(float **inputs, float **outputs, long sampleFrames);
	virtual void setProgramName(char *name);
	virtual void getProgramName(char *name);
	virtual void setParameter(long index, float value);
	virtual float getParameter(long index);
	virtual void getParameterLabel(long index, char *label);
	virtual void getParameterDisplay(long index, char *text);
	virtual void getParameterName(long index, char *text);
	/*RWD */
	virtual void setSampleRate(float sampleRate);
protected:
	spectralexaggerator *ptran;
	float exag_exag;
	float prev_exag;
	float rampsamps;
	float exagincr;
	int direction;
	char programName[32];
	float calcexag(void);
	double d_srate;
};

#endif
