/* Apvexag.cpp: main implementation code for VST plugin pvexag (c) Richard Dobson March 2001 */
/* NB parts of this file (c)1999 Steinberg Soft+Hardware GmbH */
#include <math.h>
#include "Apvexag.hpp"
#include <pvpp.h>

#define RAMPSAMPS (128)
//-----------------------------------------------------------------------------
Apvexag::Apvexag(audioMasterCallback audioMaster)
	: AudioEffectX(audioMaster, 1, 1)	// 1 program, 1 parameter only
{
	exag_exag = 0.6f;			/* slide pos: --> exag = 2 */	
	prev_exag = exag_exag;			
	rampsamps = (float) RAMPSAMPS;
	exagincr = 0.0;
	d_srate = audioMaster(&cEffect, audioMasterGetSampleRate, 0, 0, 0, 0);
	//d_srate = 44100.;
	d_srate = sampleRate;
	ptran = 0;
	/*RWD needs to throw exception, assuming host can handle it...*/
	ptran = new spectralexaggerator();
	if(!ptran->init((long)d_srate,1024,256,PVPP_STREAMING))	{
		delete ptran;
		ptran = 0;
	}

	setNumInputs(1);		// mono in
	setNumOutputs(1);		// mono out
	setUniqueID('PVXG');	// identify
	//canMono();				// makes sense to feed both inputs with the same signal
	canProcessReplacing();	// supports both accumulating and replacing output
	strcpy(programName, "PVExag");	// default program name
}

//-----------------------------------------------------------------------------------------
Apvexag::~Apvexag()
{	
	if(ptran)
		delete ptran;
}

//-----------------------------------------------------------------------------------------
void Apvexag::setProgramName(char *name)
{
	strcpy(programName, name);
}

//-----------------------------------------------------------------------------------------
void Apvexag::getProgramName(char *name)
{
	strcpy(name, programName);
}

//-----------------------------------------------------------------------------------------
void Apvexag::setParameter(long index, float value)
{
	exag_exag = value;
	if(prev_exag != exag_exag)
		exagincr = (float) fabs(exag_exag - prev_exag) / rampsamps ;
	
}

//-----------------------------------------------------------------------------------------
float Apvexag::getParameter(long index)
{
	return exag_exag;
}

//-----------------------------------------------------------------------------------------
void Apvexag::getParameterName(long index, char *label)
{
	strcpy(label, "  Exag  ");
}

//-----------------------------------------------------------------------------------------
void Apvexag::getParameterDisplay(long index, char *text)
{
	float2string((exag_exag * 5.0f) - 1.0f, text);		
}

//-----------------------------------------------------------------------------------------
void Apvexag::getParameterLabel(long index, char *label)
{
	strcpy(label, " Depth  ");
}


void Apvexag::setSampleRate (float sampleRate)
{
	AudioEffectX::setSampleRate (sampleRate);
	d_srate = sampleRate;
}



//-----------------------------------------------------------------------------------------
void Apvexag::process(float **inputs, float **outputs, long sampleFrames)
{
    float *in1  =  inputs[0];
    
    float *out1 = outputs[0];
    
	float thisexag;
	if(ptran){
		while(--sampleFrames >= 0){
			thisexag = calcexag();
			*out1++ += ptran->tick(*in1++,(thisexag * 5.0f) - 1.0f);			
		}
	}
	else {
		while(--sampleFrames >= 0)
			(*out1++) += (*in1++) * 0.1f;	/* we can hear if there is a problem... */
	}								   
}

//-----------------------------------------------------------------------------------------
void Apvexag::processReplacing(float **inputs, float **outputs, long sampleFrames)
{
    float *in1  =  inputs[0]; 
    float *out1 = outputs[0];
	float thisexag;
	if(ptran){
		while(--sampleFrames >= 0){
			thisexag = calcexag();
			*out1++ = ptran->tick(*in1++,(thisexag * 5.0f) - 1.0f);			
		}
	}
	else {
		while(--sampleFrames >= 0)
			(*out1++) = (*in1++) * 0.1f;	/* we can hear if there is a problem... */
	}
}

/************* MY FUNCTIONS */
float Apvexag::calcexag(void)
{	
	if(prev_exag== exag_exag)
		return exag_exag;

	if(exag_exag > prev_exag)
		prev_exag += exagincr;
	else if(exag_exag < prev_exag)
		prev_exag -= exagincr;

	if((float) fabs(exag_exag - prev_exag) < exagincr)
	   prev_exag = exag_exag;
	return prev_exag;
}
