/* Aaccu.hpp : definition of VSt plugin pvaccu (c) Richard Dobson March 2001 */
/* NB parts of this file (c)1999 Steinberg Soft+Hardware GmbH */

#ifndef __AACCU_H
#define __AACCU_H

#include "audioeffectx.h"
#include <transform.h>


enum accuparams { ACCU_DECAY = 0, ACCU_GLIS };

class Aaccu : public AudioEffectX
{
public:
	Aaccu(audioMasterCallback audioMaster);
	~Aaccu();

	virtual void process(float **inputs, float **outputs, long sampleFrames);
	virtual void processReplacing(float **inputs, float **outputs, long sampleFrames);
	virtual void setProgramName(char *name);
	virtual void getProgramName(char *name);
	virtual void setParameter(long index, float value);
	virtual float getParameter(long index);
	virtual void getParameterLabel(long index, char *label);
	virtual void getParameterDisplay(long index, char *text);
	virtual void getParameterName(long index, char *text);
	/*RWD */
	virtual void setSampleRate(float sampleRate);
protected:
	accutransformer *ptran;
	float glis;
	float decay;
	float prev_glis;
	float prev_decay;
	float rampsamps;
	float glisincr;
	float decayincr;	
	char programName[32];
	float calcglis(void);
	float calcdecay(void);
	double d_srate;
};

#endif
