/* Aaccu.cpp main implementation file for pvaccu VST plugin (c) Richard Dobson March 2001 */
/* NB parts of this file (c)1999 Steinberg Soft+Hardware GmbH */

#include <math.h>
#include "Aaccu.hpp"
#include <pvpp.h>

#define RAMPSAMPS (128)
#define GLIS_RANGE (2.0f)
#define GLIS_RANGE2 (4.0f)


extern bool oome;			/*RWD */
//-----------------------------------------------------------------------------
Aaccu::Aaccu(audioMasterCallback audioMaster)
	: AudioEffectX(audioMaster, 1, 2)	// 1 program, 2 parameters only
{
			
	rampsamps = (float) RAMPSAMPS;
	glisincr = 0.0;
	decayincr = 0.0f;
	decay = 0.25;
	glis = 0.5;		/* start with no glis */
	prev_decay = decay;
	prev_glis = glis;
	d_srate = audioMaster(&cEffect, audioMasterGetSampleRate, 0, 0, 0, 0);
	//d_srate = 44100.;
	d_srate = sampleRate;
	ptran = 0;
	/*RWD no exception handling used   */
	ptran = new accutransformer();
	if((ptran== 0) || (!ptran->init((long)d_srate,1024,256,PVPP_STREAMING)))	{
		delete ptran;
		ptran = 0;
		oome = true;
		return;
	}
	

	setNumInputs(1);		// mono in
	setNumOutputs(1);		// mono out
	setUniqueID('PVCU');	// identify
	//canMono();				// makes sense to feed both inputs with the same signal
	canProcessReplacing();	// supports both accumulating and replacing output
	strcpy(programName, "PV-ACCUMULATE");	// default program name
}

//-----------------------------------------------------------------------------------------
Aaccu::~Aaccu()
{	
	if(ptran)
		delete ptran;
}

//-----------------------------------------------------------------------------------------
void Aaccu::setProgramName(char *name)
{
	strcpy(programName, name);
}

//-----------------------------------------------------------------------------------------
void Aaccu::getProgramName(char *name)
{
	strcpy(name, programName);
}

//-----------------------------------------------------------------------------------------
void Aaccu::setParameter(long index, float value)
{
	
	switch(index){
	case ACCU_GLIS:		
		glis = value;					
		if(prev_glis != glis)
			glisincr = (float) fabs(glis - prev_glis) / rampsamps ;
		break;
	case ACCU_DECAY:
		decay = value;
		if(prev_decay != decay)
			decayincr = (float) fabs(decay - prev_decay) / rampsamps;
		break;
	default:
		break;
	}
}

//-----------------------------------------------------------------------------------------
float Aaccu::getParameter(long index)
{
	switch(index){
	case ACCU_GLIS:
		return glis;
	case ACCU_DECAY:
		return decay;
	default:
		break;
	}
	return 0.0;
}

//-----------------------------------------------------------------------------------------
void Aaccu::getParameterName(long index, char *label)
{
	switch(index){
	case ACCU_GLIS:
		strcpy(label, "  Glis  ");
		break;
	case ACCU_DECAY:
		strcpy(label,"  Decay  ");
		break;
	default:
		break;
	}
}

//-----------------------------------------------------------------------------------------
void Aaccu::getParameterDisplay(long index, char *text)
{
	switch(index){
	case ACCU_GLIS:
		float2string(glis * GLIS_RANGE2 - GLIS_RANGE, text);
		break;
	case ACCU_DECAY:
		float2string(decay,text);
		break;
	default:
		break;
	}
}

//-----------------------------------------------------------------------------------------
void Aaccu::getParameterLabel(long index, char *label)
{
	if(index== ACCU_GLIS)
		strcpy(label, " Octaves ");
	else
		strcpy(label, "FB level ");

}


void Aaccu::setSampleRate (float sampleRate)
{
	AudioEffectX::setSampleRate (sampleRate);
	d_srate = sampleRate;
}



//-----------------------------------------------------------------------------------------
void Aaccu::process(float **inputs, float **outputs, long sampleFrames)
{
    float *in1  =  inputs[0];
    //float *in2  =  inputs[1];
    float *out1 = outputs[0];
    //float *out2 = outputs[1];
	float thisglis, thisdecay;
	if(ptran){
		while(--sampleFrames >= 0){
			thisglis = calcglis();
			thisdecay = calcdecay();
			*out1++ += ptran->tick(*in1++,thisdecay,thisglis);
			
		}
	}
	else {
		while(--sampleFrames >= 0)
			(*out1++) += (*in1++) * 0.1f;	/* we can hear if there is a problem... */
	}		
}

//-----------------------------------------------------------------------------------------
void Aaccu::processReplacing(float **inputs, float **outputs, long sampleFrames)
{
    float *in1  =  inputs[0]; 
    float *out1 = outputs[0];
	float thisglis, thisdecay;
	if(ptran){
		while(--sampleFrames >= 0){
			thisglis = calcglis();
			thisdecay = calcdecay();
			*out1++ = ptran->tick(*in1++,thisdecay,thisglis);			
		}
	}
	else {
		while(--sampleFrames >= 0)
			(*out1++) = (*in1++) * 0.1f;	/* we can hear if there is a problem... */
	}
}

/************* MY FUNCTIONS */
float Aaccu::calcglis(void)
{	
	
	if(prev_glis== glis)
		return  glis * GLIS_RANGE2 - GLIS_RANGE;

	if(glis > prev_glis)
		prev_glis += glisincr;
	else if(glis < prev_glis)
		prev_glis -= glisincr;

	if((float) fabs(glis - prev_glis) < glisincr)
	   prev_glis = glis;

	return prev_glis * GLIS_RANGE2 - GLIS_RANGE;
}

float Aaccu::calcdecay(void)
{	
	if(prev_decay== decay)
		return decay;

	if(decay > prev_decay)
		prev_decay += decayincr;
	else if(decay < prev_decay)
		prev_decay -= decayincr;

	if((float) fabs(decay - prev_decay) < decayincr)
	   prev_decay = decay;
	return prev_decay;	 
}

