/* transform.h : GUI-independent spectral transformation classes */
/* License Pending. This code is Copyright (c) Trevor Wishart, Richard Dobson and 
 * Composers Desktop Project, March 2001. This code is made freely available for non-commercial use.
 * This copyright notice should be preserved in any redistributed and/or modified version.
 */


/* definition of the phase vococder class wrapper */
#include <pvpp.h>


extern "C" {
#include <plugins.h>
}

/* You may notice that these classes have a lot in common. I noticed this too! */


class spectralexaggerator {

public:
	spectralexaggerator();
	virtual ~spectralexaggerator();
	bool init(long samplerate,long fftlen,long overlap,pvocmode mode);
	float tick(float insamp,float exag);

private:
	phasevocoder *inpv, *outpv;
	float *frame;
	float *inbuf,*outbuf;
	long inptr,outptr,decfac,srate;
	long nbins;
protected:
	void cleanup();
};





class spectraltransposer {
public:
	spectraltransposer();
	virtual ~spectraltransposer();
	bool init(long samplerate,long fftlen,long overlap,pvocmode mode);
	float tick(float insamp,float semitones);

private:
	phasevocoder *inpv, *outpv;
	float *frame;
	float *inbuf,*outbuf;
	float *amp,*freq;
	float nyquist,chwidth;
	long inptr,outptr,decfac,srate;
	long nbins;
	
protected:
	void cleanup();

};



class accutransformer {

public:
	accutransformer();
	virtual ~accutransformer();
	bool init(long samplerate,long fftlen,long overlap,pvocmode mode);
	float tick(float insamp,float decay,float glis);

private:
	phasevocoder *inpv, *outpv;
	float *frame, *framestore;
	float *inbuf,*outbuf;
	float nyquist,arate,frametime;
	long inptr,outptr,decfac,srate;
	long nbins;
protected:
	void cleanup();
};
